clear all; clc;
%%
Helix_up= 1;
Helix_down = 0;
grid = 0;
place = 1;
%%
if Helix_up
    traj_file='Trajectory_fivecoil_up.csv';
    spike_file='encoded_helix_t20p1_b1.5pi_3d_test_up.csv';
else 
    traj_file='Trajectory_fivecoil_down.csv';
    spike_file='encoded_helix_t20p1_b1.5pi_3d_test_down.csv';
end
traj_data=csvread(traj_file);
spike_data=csvread(spike_file);
%%
if grid
    g_cells = [2,3,29,35,39,40,42,44,47];
    cells = g_cells;
else
    p_cells = [1, 6, 8, 15, 18, 19, 20, 21, 23, 24, 27, 31, 34, 36, 41, 43, 45, 46, 48];
    cells = p_cells;
end
    

%% seperate all the coils
num_coils = 5; coil_dat = {}; coil_dat_spk = {}; 
edge_hist = 1:6:360;
for k = cells
    angles = [];
    ot = spike_data(:,k);
    ot_mean = mean(ot);
    ot_std = std(ot);
    thresh = ot_mean + 1.5*ot_std;
    spk_cell = ot > thresh;
    dat = [traj_data spk_cell];
    for i = 1:num_coils
        if i == num_coils
            temp = i>=traj_data(:,3) & traj_data(:,3)>=(i-1) ;
        else
            temp = i>traj_data(:,3) & traj_data(:,3)>=(i-1);
        end
        temp_coil = dat(temp,:); temp_coil_spk = temp_coil(temp_coil(:,4)==1, :);
        coil_dat{k,i} = temp_coil;
        coil_dat_spk{k,i} = temp_coil_spk;
        ang = quad(temp_coil(:,1), temp_coil(:,2));
        angles = [angles ang.*temp_coil(:,4)];
    end

    figure() 
    for p = 1:num_coils
        subplot(5,1,num_coils-p+1)
        histogram(angles(angles(:, p) > 0, p), edge_hist, 'FaceColor','#ff4d01','EdgeColor','#ff4d01')
        xlim([0 360]);
%         axis on;
  
        set(gca,'XTick',[]); set(gca,'YTick',[])
        axis on;
    end
    sgtitle(['neuron ', num2str(k)]);
%     break;
    savefig(['place_3D_lin', num2str(k)]);
    saveas(gcf, ['place_3D_lin', num2str(k), '.png'])
end

% %% plotting histogram
% p = k; figure()
% firr = spike_data(:,p) > (0.4*max(spike_data(:,p)));
% scatter3(traj_data(:,1), traj_data(:,2), traj_data(:,3)); hold on
% scatter3(traj_data(firr,1), traj_data(firr,2), traj_data(firr,3), 'MarkerFaceColor', 'red', 'MarkerEdgeColor','red')
% hold off;

%% ############## All Statistical Analysis and Plots for the manuscript for Helix ###################
%% t-test2 minor axis flat arena and helical maze (Place cells)
place_2d_minor = [0.1760485701	0.3229981902	0.5495352998	0.5235088226	0.4103321728	0.2618040259	0.6348144702	0.3818947259	0.2426696942	0.4856625345	0.04618802154	0.3337530245	0.3975651699	0.2342174095	0.07096424943	0.167710531	0.5396179497	0.07779652996	0.07302967433	0.08326663998	0.4420635688	0.04618802154	0.1292714629	0.6348500116	0.3967947356	0.430313642	0.1596428675	0.3864839154	0.07344809129	0.4223801212	0.1110899828	0.6087874189	0.1593915278	0.2190659415	0.3075356453];
place_3d_minor = [0.84524	0.553228	0.581896	0.43616	0.704888	0.355072	0.51438	0.546812	0.48892	0.536308	0.257164	1.12132	0.154164	0.046188	0.337916	0.402792	0.349768	0.650408	0.787632	0.336856	0.472176	0.531224	0.444852	0.522744	0.47112	0.55718	0.482044	0.21294	0.3989	0.10328	0.34954	0.34372	0.510324	0.244212	0.569104	0.236196	0.236196 0.939092	0.598516	0.552532	0.409744	0.386288	0.594652	0.477864	0.52892	0.281416	0.551468	0.468632	0.524804	0.21802	0.21802	0.166532	1.179956	0.625804	0.324912	0.4026	0.380872	0.650772	0.768444	0.293868	0.461972	0.497328	0.453156	0.539472	0.409576	0.549128	0.495784	0.391908	0.391372	0.3325	0.344332	0.544868	0.242712	0.5837	0.245676	0.245676];
[h, p, ci, stats] = ttest2(place_2d_minor, place_3d_minor);
place_2d_minor_mean = mean(place_2d_minor);
place_2d_minor_std = std(place_2d_minor);
place_3d_minor_mean = mean(place_3d_minor);
place_3d_minor_std = std(place_3d_minor);

%% ttest2 minor axis Helical and major axis flat arena (Place cells)
% place_3d_minor = [0.785,	1.256,	0.942,	0.471,	0.471,	0.471,	1.256,	0.628,	1.256,	0.471,	0.471,	0.471,	0.785,	0.785,	0.942,	1.413,	0.785,	0.785,	0.785,	0.785,	1.256,	0.628,	0.471,	1.57,	0.785,	0.785,	0.785,	0.628,	0.942,	0.785,	0.942,	1.099,	0.942,	0.785,	0.628,	0.942,	0.942,	0.471,	0.942,	0.785,	2.983,	0.628,	0.785,	0.628,	0.471,	1.256,	1.413,	0.628,	0.942,	0.628,	0.785,	0.942,	0.628,	1.256,	1.256,	0.942,	0.942,	0.628,	0.785,	0.628,	0.471,	0.942,	0.785,	0.942,	0.942,	0.942,	0.942,	2.041,	0.628,	0.628,	0.785,	0.628,	0.471,	0.785,	1.099,	1.256,	0.785,	0.942,	1.099,	0.628,	1.57,	0.628,	0.628,	0.628,	0.628,	1.099,	0.628,	0.628,	0.471,	2.198,	0.942,	1.256,	0.942,	0.785,	1.099,	0.628,	0.628,	0.628,	1.099,	0.942,	0.628,	0.785,	0.628,	0.785,	0.942,	1.099,	0.785,	0.471,	0.471,	1.099,	0.785,	0.785, 0.628,	0.471,	0.785,	0.471,	0.471,	1.256,	0.942,	1.256,	0.628,	0.942,	0.785,	0.785,	0.471,	0.785,	1.256,	1.099,	0.628,	0.471,	1.413,	0.471,	0.942,	1.413,	0.942,	0.785,	1.099,	1.099,	1.099,	0.785,	0.471,	0.628,	0.785,	1.099,	0.471,	0.942,	1.256,	0.628,	0.628,	0.628,	0.628,	0.785,	1.57,	0.785,	0.628,	0.628,	1.413,	0.942,	0.942,	0.942,	0.628,	1.099,	1.256,	0.628,	0.628,	1.413,	0.942,	0.942,	0.628,	0.628,	0.942,	0.785,	0.628,	0.628,	0.785,	0.785,	0.628,	0.942,	1.256,	0.785,	1.256,	0.942,	0.785,	0.785,	1.256,	0.628,	0.628,	0.628,	1.57,	0.942,	0.942,	0.785,	0.628,	1.256,	0.471,	0.785,	1.57,	0.785,	1.57,	1.413,	0.942,	0.785,	0.471,	1.099,	0.628,	1.099,	0.785,	0.942,	0.785,	0.471,	0.785,	0.942,	0.785,	0.942,	1.256,	0.628,	0.628,	0.785];
% place_2d_major = [0.777752852121663,	0.758594785132971,	0.537943452755943,	0.667326390651934,	0.395897327444314,	0.681362986691869,	0.596664984468103,	0.478108448723749,	0.490488303119163,	0.62276701592062,	0.476129430444291,	0.392740974102209,	0.605318697475111,	0.670807008654466,	0.614283245504354,	0.387160302842611,	0.481696289501409,	0.452687345379351,	0.602818139911889,	0.459052066694343,	0.58526177303878,	0.529233170547014,	0.600765033338677,	0.490172632278071,	0.641731324666737,	0.424264358794166,	0.637397996304046,	0.675702336766034,	0.619047379915457,	0.591873426115854,	0.536152821412371,	0.490746185643246,	0.482261739103446,	0.519923200327112,	0.680178804999432,	0.66676174197458,	0.329914439536929,	0.629760713012783,	0.588873690334626,	0.433790180777203,	0.655141529593263,	0.357794688279649,	0.425997808795614,	0.362905883490623,	0.731076630544209,	0.659572877473163,	0.362905883490623,	0.401358238203914,	0.52017765041616,	0.634959972118166,	0.45560794343492,	0.422738662826946,	0.735250100520483,	0.762344622243946];
% [h, p, ci, stats] = ttest2(place_3d_minor, place_2d_major);
% place_3d_minor_mean = mean(place_3d_minor);
% place_3d_minor_std = std(place_3d_minor);
% place_2d_major_mean = mean(place_2d_major);
% place_2d_major_std = std(place_2d_major);

%% ttest2 major and minor axis helical (Place cells)
place_3d_minor = [0.84524	0.553228	0.581896	0.43616	0.704888	0.355072	0.51438	0.546812	0.48892	0.536308	0.257164	1.12132	0.154164	0.046188	0.337916	0.402792	0.349768	0.650408	0.787632	0.336856	0.472176	0.531224	0.444852	0.522744	0.47112	0.55718	0.482044	0.21294	0.3989	0.10328	0.34954	0.34372	0.510324	0.244212	0.569104	0.236196	0.236196 0.939092	0.598516	0.552532	0.409744	0.386288	0.594652	0.477864	0.52892	0.281416	0.551468	0.468632	0.524804	0.21802	0.21802	0.166532	1.179956	0.625804	0.324912	0.4026	0.380872	0.650772	0.768444	0.293868	0.461972	0.497328	0.453156	0.539472	0.409576	0.549128	0.495784	0.391908	0.391372	0.3325	0.344332	0.544868	0.242712	0.5837	0.245676	0.245676];
place_3d_major = [5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	1	5	5	5	3	5	5	5	2	2	1	5	3	5	1	5	1	1 5	5	5	5	4	5	5	5	1	5	5	5	2	1	5	5	5	5	5	5	5	5	1	5	5	5	5	5	5	5	5	4	5	5	5	4	5	1	1];
[h, p, ci, stats] = ttest2(place_3d_minor, place_3d_major);
place_3d_minor_mean = mean(place_3d_minor);
place_3d_minor_std = std(place_3d_minor);
place_3d_major_mean = mean(place_3d_major);
place_3d_major_std = std(place_3d_major);
% plot(1:230, place_3d_major)

%% ttest2 aspect ratio aspect ratio helical and 2d (place cells)
place_3d_aspectR = [5.915479627	9.037865039	8.59260074	11.46368305	7.093325464	14.08165105	9.720440142	9.143910521	10.22662194	9.323000962	19.44284581	4.459030428	32.43299344	108.2532259	14.79657666	12.41335478	14.29518995	7.687482319	6.34814228	2.968627544	10.5892718	9.412225351	11.2396932	5.738946788	10.6130073	8.973760724	10.37249712	9.392317085	5.013787917	9.682416731	14.3045145	8.728034447	9.797697149	4.094802876	8.785740392	4.233771952	4.233771952 5.324291976	8.353995549	9.049249636	12.20274122	12.94371039	6.726623302	10.46322803	9.453225441	17.76729113	1.813341844	10.6693525	9.527366407	22.93367581	9.173470324	6.00485192	4.237446142	7.989722022	15.38878219	12.41927471	13.12776996	7.683182436	6.506655007	17.01444186	2.164633354	10.05372712	11.0337279	9.268321618	12.20774655	9.105345202	10.08503703	12.75809629	12.77556902	12.03007519	14.52086939	9.1765345	20.60054715	6.852835361	20.35200834	4.070401667];
place_2d_aspectR = [2.904928466	2.475974833	1.415131231	1.527976687	1.439957401	1.127139174	1.092725463	1.416433403	2.058418221	1.154840966	2	1.923112226	1.421609739	1.283074299	2.809996831	2.426163615	1.441112266	3.933868321	2	1.467598771	1.262814562	4	1.82185316	1.108666796	1.78749679	1.272893473	3.071448571	1.359898364	3.003033072	1.492775262	3.119286799	1.142316185	2.525470603	2.576393719	1.843020881];
[h, p, ci, stats] = ttest2(place_3d_aspectR, place_2d_aspectR);
place_3d_aspectR_mean = mean(place_3d_aspectR);
place_3d_aspectR_std = std(place_3d_aspectR);
place_2d_aspectR_mean = mean(place_2d_aspectR);
place_2d_aspectR_std = std(place_2d_aspectR);
%% field extend in coils (PLAce cells)
place_3d_major = [5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	1	5	5	5	3	5	5	5	2	2	1	5	3	5	1	5	1	1 5	5	5	5	4	5	5	5	1	5	5	5	2	1	5	5	5	5	5	5	5	5	1	5	5	5	5	5	5	5	5	4	5	5	5	4	5	1	1];
%place_3d_major = [4, 1,	1,	1,	3,	2,	5,	5,	3,	2,	1,	1,	5,	3,	2,	3,	2,	1,	1,	1,	4,	3,	3,	2,	1,	5,	4,	3,	2,	2,	5,	5,	3,	2,	2,	3,	2,	5,	2,	5,	5,	4,	1,	1,	1,	3,	3,	2,	2,	1,	5,	3,	3,	2,	5,	5,	2,	2,	1,	1,	1,	4,	4,	2,	2,	1,	1,	4,	3,	4,	2,	2,	2,	1,	5,	2,	2,	1,	5,	2,	3,	2,	1,	1,	1,	5,	3,	3,	1,	5,	4,	1,	1,	3,	2,	2,	2,	1,	3,	3,	2,	1,	1,	4,	5,	3,	2,	1,	1,	5,	5,	2, 4,	1,	1,	1,	3,	2,	5,	5,	3,	2,	1,	1,	5,	3,	2,	3,	2,	1,	1,	1,	4,	3,	3,	2,	1,	5,	4,	3,	2,	2,	5,	5,	3,	2,	2,	3,	2,	5,	2,	5,	5,	4,	1,	1,	1,	3,	3,	2,	2,	1,	5,	3,	3,	2,	5,	5,	2,	2,	1,	1,	1,	4,	4,	2,	2,	1,	1,	4,	3,	4,	2,	2,	2,	1,	5,	2,	2,	1,	5,	2,	3,	2,	1,	1,	1,	5,	3,	3,	1,	5,	4,	1,	1,	3,	2,	2,	2,	1,	3,	3,	2,	1,	1,	4,	5,	3,	2,	1,	1,	5,	5,	2];
count5 = sum(place_3d_major == 5);
count4 = sum(place_3d_major == 4);
count3 = sum(place_3d_major == 3);
count2 = sum(place_3d_major == 2);
count1 = sum(place_3d_major == 1);
X = [1,2,3,4,5];
sum_count = count1 + count2 + count3 + count4 + count5;
Y = [count1*100/(sum_count), count2*100/(sum_count), count3*100/(sum_count), count4*100/(sum_count), count5*100/(sum_count)];
figure;
bar(X, Y, 'FaceColor','#808080');
xlabel("Vertical field size (coils)");
ylabel("Percentage fields");
set(gca, 'FontSize', 20);
%% t-test2 minor axis flat arena and helical maze (Grid cells)
grid_2d_minor = [0.6207601075	0.1886146333	0.4178419166	0.2070223147	0.4150641774	0.1535395488	0.1360547741	0.4199236926	0.5834560761	0.3064781682	0.1688573083	0.4854188646	0.4990691328	0.1337216794	0.2331584889	0.1062078215	0.3149181194	0.3908220658	0.2277678779	0.2219151459	0.3051874927	0.4063136432	0.2871462467	0.2377255883	0.2307782242	0.1154700538	0.1154700538	0.1680581342	0.05773502692];
grid_3d_minor = [0.46474	0.551735	0.344095	0.754665	0.517965	0.517155	0.591845	0.4119	0.54633	0.23805	0.76189	0.39096	0.87562	0.452965	0.738285	0.48321	0.462525	0.33785	0.4483907304	0.5714453888	0.8580920657	0.5053760316	0.4947534898	0.3591251	0.438195039	0.6236926937	0.3902599898	0.5803358673	0.8052657847	0.4662061971	0.8672238389	0.1290994449	0.6846945321	0.5525944225	0.505661094	0.3320823036];
[h, p, ci, stats] = ttest2(grid_2d_minor, grid_3d_minor);
grid_2d_minor_mean = mean(grid_2d_minor);
grid_2d_minor_std = std(grid_2d_minor);
grid_3d_minor_mean = mean(grid_3d_minor);
grid_3d_minor_std = std(grid_3d_minor);
%% ttest2 major and minor axis helical (Grid cells)
grid_3d_major = [5	5	3	5	5	5	5	5	5	5	5	4	5	4	5	5	5	2	5	5	5	5	5	1	5	5	5	5	5	4	5	4	5	5	5	4];
grid_3d_minor = [0.46474	0.551735	0.344095	0.754665	0.517965	0.517155	0.591845	0.4119	0.54633	0.23805	0.76189	0.39096	0.87562	0.452965	0.738285	0.48321	0.462525	0.33785	0.4483907304	0.5714453888	0.8580920657	0.5053760316	0.4947534898	0.3591251	0.438195039	0.6236926937	0.3902599898	0.5803358673	0.8052657847	0.4662061971	0.8672238389	0.1290994449	0.6846945321	0.5525944225	0.505661094	0.3320823036];
[h, p, ci, stats] = ttest2(grid_3d_minor, grid_3d_major);
grid_3d_minor_mean = mean(grid_3d_minor);
grid_3d_minor_std = std(grid_3d_minor);
grid_3d_major_mean = mean(grid_3d_major);
grid_3d_major_std = std(grid_3d_major);
%% ttest2 aspect ratio aspect ratio helical and 2d (grid cells)
grid_3d_aspectR = [10.75870379	9.062321586	8.718522501	6.625456328	9.653161893	9.66828127	8.448157879	12.13886866	9.151977742	21.00399076	6.562627151	10.2312257	5.710239602	8.830704359	6.772452373	10.34746797	10.81022647	5.919786888	11.15098877	8.749742491	5.826880587	9.893623139	10.10604291	2.784544996	11.41044411	8.016768595	12.81197184	8.615700461	6.209130072	8.579894529	5.765524165	30.98386677	7.302526551	9.04822741	9.888045687	12.04520674];
grid_2d_aspectR = [1.214614559	2.70530065	1.288873021	1.860842816	1.145056963	3.300931227	2.670717671	1.38489209	1.102740354	1.835011239	3.649505894	1.238219588	1.276716825	3.019269222	1.475498297	2.800186721	1.55199321	1.719570404	1.608891924	2.006393573	1.766183673	1.255467577	2.413715449	1.288309062	2.845367322	1.5	1	1.678583124	2];
[h, p, ci, stats] = ttest2(grid_3d_aspectR, grid_2d_aspectR);
grid_3d_aspectR_mean = mean(grid_3d_aspectR);
grid_3d_aspectR_std = std(grid_3d_aspectR);
grid_2d_aspectR_mean = mean(grid_2d_aspectR);
grid_2d_aspectR_std = std(grid_2d_aspectR);

%% field extend in coils (Grid cells)
grid_3d_major = [5	5	3	5	5	5	5	5	5	5	5	4	5	4	5	5	5	2	5	5	5	5	5	1	5	5	5	5	5	4	5	4	5	5	5	4];
count5 = sum(grid_3d_major == 5);
count4 = sum(grid_3d_major == 4);
count3 = sum(grid_3d_major == 3);
count2 = sum(grid_3d_major == 2);
count1 = sum(grid_3d_major == 1);
X = [1,2,3,4,5];
sum_count = count1 + count2 + count3 + count4 + count5;
Y = [count1*100/(sum_count), count2*100/(sum_count), count3*100/(sum_count), count4*100/(sum_count), count5*100/(sum_count)];
figure;
p1= bar(X, Y, 'FaceColor','#808080');
%set(p1,'FaceColor','red');
xlabel("Vertical field size (coils)");
ylabel("Percentage fields");
set(gca, 'FontSize', 20);
%% Major and Minor axis length place cells
place_3d_minor = [0.84524	0.553228	0.581896	0.43616	0.704888	0.355072	0.51438	0.546812	0.48892	0.536308	0.257164	1.12132	0.154164	0.046188	0.337916	0.402792	0.349768	0.650408	0.787632	0.336856	0.472176	0.531224	0.444852	0.522744	0.47112	0.55718	0.482044	0.21294	0.3989	0.10328	0.34954	0.34372	0.510324	0.244212	0.569104	0.236196	0.236196 0.939092	0.598516	0.552532	0.409744	0.386288	0.594652	0.477864	0.52892	0.281416	0.551468	0.468632	0.524804	0.21802	0.21802	0.166532	1.179956	0.625804	0.324912	0.4026	0.380872	0.650772	0.768444	0.293868	0.461972	0.497328	0.453156	0.539472	0.409576	0.549128	0.495784	0.391908	0.391372	0.3325	0.344332	0.544868	0.242712	0.5837	0.245676	0.245676];
place_3d_major = [5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	1	5	5	5	3	5	5	5	2	2	1	5	3	5	1	5	1	1 5	5	5	5	4	5	5	5	1	5	5	5	2	1	5	5	5	5	5	5	5	5	1	5	5	5	5	5	5	5	5	4	5	5	5	4	5	1	1];
place_2d_major = [0.7539842639	0.5102592901	0.5385451732	0.3852359872	0.4752721265	0.5068234914	0.3633638894	0.5815490003	0.6434005597	0.5623908832	0.6162457419	0.6010551467	0.6371699586	0.4037417508	0.3440249532	0.2974017314	0.4887507829	0.6720460575	0.3664538995	0.4452491224	0.5390171666	0.510113605	0.6930893318	0.3062640295	0.6566488177	0.1732050808	0.1154700538	0.282099548	0.1154700538];
place_2d_minor = [0.1760485701	0.3229981902	0.5495352998	0.5235088226	0.4103321728	0.2618040259	0.6348144702	0.3818947259	0.2426696942	0.4856625345	0.04618802154	0.3337530245	0.3975651699	0.2342174095	0.07096424943	0.167710531	0.5396179497	0.07779652996	0.07302967433	0.08326663998	0.4420635688	0.04618802154	0.1292714629	0.6348500116	0.3967947356	0.430313642	0.1596428675	0.3864839154	0.07344809129	0.4223801212	0.1110899828	0.6087874189	0.1593915278	0.2190659415	0.3075356453];
place_3d_minor_mean = mean(place_3d_minor);
place_3d_major_mean = mean(place_3d_major);
place_2d_major_mean = mean(place_2d_major);
place_2d_minor_mean = mean(place_2d_minor);

place_3d_minor_std = std(place_3d_minor);
place_3d_major_std = std(place_3d_major);
place_2d_major_std = std(place_2d_major);
place_2d_minor_std = std(place_2d_minor);

std_err_minor = [place_2d_minor_std, place_3d_minor_std];
std_err_major = [place_2d_major_std, place_3d_major_std];
std_err = [std_err_minor; std_err_major];

bar_dat = [place_2d_minor_mean, place_3d_minor_mean; place_2d_major_mean, place_3d_major_mean];
err = [place_2d_minor_std, place_3d_minor_std; place_2d_major_std, place_3d_major_std];


env_type = {'flat arena', 'Helical maze', 'flat arena', 'Helical maze'};
col = [1,1,1; 0.5,0.5,0.5; 1,1,1; 0.5,0.5,0.5];
        for bb = 1:4
            % bb is bars in bar graph iterator to have different colors
            if bb <3
            bb
            b = bar(0.1 + 0.1*bb, bar_dat(bb),0.1, 'DisplayName',env_type{1,bb}, 'LineWidth', 1.0);
            set(b,'FaceColor',col(bb,:))
            %legend(b, env_type{1,bb});
            %legend(b, env_type{2,bb});
            hold on
            er = errorbar(0.1 + 0.1*bb ,bar_dat(bb),err(bb),err(bb), 'HandleVisibility','off');    
            er.Color = [0 0 0];  
            er.LineWidth = 1.0;
            er.LineStyle = 'none';  
            hold on
            
            else 
            b = bar(0.15 + 0.1*bb, bar_dat(bb) ,0.1, 'HandleVisibility','off', 'LineWidth', 1.0);
            bb
            set(b,'FaceColor',col(bb,:))
            hold on
            er = errorbar(0.15 + 0.1*bb ,bar_dat(bb) ,err(bb),err(bb), 'HandleVisibility','off');    
            er.Color = [0 0 0];  
            er.LineWidth = 1.0;
            er.LineStyle = 'none';  
            hold on
            end
        end
 set(gca, 'xtick', [0.25, 0.5])
 set(gca, 'xticklabel',{'Minor Axis', 'Major Axis'})
xlim([0.0,0.8]);
legend;
ylabel('Field length (units)');

%% Major and Minor axis length grid cells
grid_3d_minor = [0.46474	0.551735	0.344095	0.754665	0.517965	0.517155	0.591845	0.4119	0.54633	0.23805	0.76189	0.39096	0.87562	0.452965	0.738285	0.48321	0.462525	0.33785	0.4483907304	0.5714453888	0.8580920657	0.5053760316	0.4947534898	0.3591251	0.438195039	0.6236926937	0.3902599898	0.5803358673	0.8052657847	0.4662061971	0.8672238389	0.1290994449	0.6846945321	0.5525944225	0.505661094	0.3320823036];
grid_3d_major = [5	5	3	5	5	5	5	5	5	5	5	4	5	4	5	5	5	2	5	5	5	5	5	1	5	5	5	5	5	4	5	4	5	5	5	4];
grid_2d_major = [0.7539842639	0.5102592901	0.5385451732	0.3852359872	0.4752721265	0.5068234914	0.3633638894	0.5815490003	0.6434005597	0.5623908832	0.6162457419	0.6010551467	0.6371699586	0.4037417508	0.3440249532	0.2974017314	0.4887507829	0.6720460575	0.3664538995	0.4452491224	0.5390171666	0.510113605	0.6930893318	0.3062640295	0.6566488177	0.1732050808	0.1154700538	0.282099548	0.1154700538];
grid_2d_minor = [0.6207601075	0.1886146333	0.4178419166	0.2070223147	0.4150641774	0.1535395488	0.1360547741	0.4199236926	0.5834560761	0.3064781682	0.1688573083	0.4854188646	0.4990691328	0.1337216794	0.2331584889	0.1062078215	0.3149181194	0.3908220658	0.2277678779	0.2219151459	0.3051874927	0.4063136432	0.2871462467	0.2377255883	0.2307782242	0.1154700538	0.1154700538	0.1680581342	0.05773502692];
grid_3d_minor_mean = mean(grid_3d_minor);
grid_3d_major_mean = mean(grid_3d_major);
grid_2d_major_mean = mean(grid_2d_major);
grid_2d_minor_mean = mean(grid_2d_minor);

grid_3d_minor_std = std(grid_3d_minor);
grid_3d_major_std = std(grid_3d_major);
grid_2d_major_std = std(grid_2d_major);
grid_2d_minor_std = std(grid_2d_minor);

std_err_minor = [grid_2d_minor_std, grid_3d_minor_std];
std_err_major = [grid_2d_major_std, grid_3d_major_std];
std_err = [std_err_minor; std_err_major];

bar_dat = [grid_2d_minor_mean, grid_3d_minor_mean; grid_2d_major_mean, grid_3d_major_mean];
err = [grid_2d_minor_std, grid_3d_minor_std; grid_2d_major_std, grid_3d_major_std];


env_type = {'flat arena', 'Helical maze', 'flat arena', 'Helical maze'};
col = [1,1,1; 0.5,0.5,0.5; 1,1,1; 0.5,0.5,0.5];
        for bb = 1:4
            % bb is bars in bar graph iterator to have different colors
            if bb <3
            bb
            b = bar(0.1 + 0.1*bb, bar_dat(bb),0.1, 'DisplayName',env_type{1,bb}, 'LineWidth', 1.0);
            set(b,'FaceColor',col(bb,:))
            %legend(b, env_type{1,bb});
            %legend(b, env_type{2,bb});
            hold on
            er = errorbar(0.1 + 0.1*bb ,bar_dat(bb),err(bb),err(bb), 'HandleVisibility','off');    
            er.Color = [0 0 0];  
            er.LineWidth = 1.0;
            er.LineStyle = 'none';  
            hold on
            
            else 
            b = bar(0.15 + 0.1*bb, bar_dat(bb) ,0.1, 'HandleVisibility','off', 'LineWidth', 1.0);
            bb
            set(b,'FaceColor',col(bb,:))
            hold on
            er = errorbar(0.15 + 0.1*bb ,bar_dat(bb) ,err(bb),err(bb), 'HandleVisibility','off');    
            er.Color = [0 0 0];  
            er.LineWidth = 1.0;
            er.LineStyle = 'none';  
            hold on
            end
        end
 set(gca, 'xtick', [0.25, 0.5])
 set(gca, 'xticklabel',{'Minor Axis', 'Major Axis'})
xlim([0.0,0.8]);
legend;
ylabel('Field length (units)');
%% Aspect ratio plot grid
grid_3d_aspectR = [10.75870379	9.062321586	8.718522501	6.625456328	9.653161893	9.66828127	8.448157879	12.13886866	9.151977742	21.00399076	6.562627151	10.2312257	5.710239602	8.830704359	6.772452373	10.34746797	10.81022647	5.919786888	11.15098877	8.749742491	5.826880587	9.893623139	10.10604291	2.784544996	11.41044411	8.016768595	12.81197184	8.615700461	6.209130072	8.579894529	5.765524165	30.98386677	7.302526551	9.04822741	9.888045687	12.04520674];
grid_2d_aspectR = [1.214614559	2.70530065	1.288873021	1.860842816	1.145056963	3.300931227	2.670717671	1.38489209	1.102740354	1.835011239	3.649505894	1.238219588	1.276716825	3.019269222	1.475498297	2.800186721	1.55199321	1.719570404	1.608891924	2.006393573	1.766183673	1.255467577	2.413715449	1.288309062	2.845367322	1.5	1	1.678583124	2];
grid_3d_aspectR_mean = mean(grid_3d_aspectR);
grid_2d_aspectR_mean = mean(grid_2d_aspectR);

grid_3d_aspectR_std = std(grid_3d_aspectR);
grid_2d_aspectR_std = std(grid_2d_aspectR);

bar_dat = [grid_2d_aspectR_mean; grid_3d_aspectR_mean];
err = [grid_2d_aspectR_std; grid_3d_aspectR_std];

env_type = {'flat arena', 'Helical maze'};
col = [1,1,1; 0.5,0.5,0.5];
        for bb = 1:2
            % bb is bars in bar graph iterator to have different colors
            if bb < 2
            bb
            b = bar(0.1 + 0.1*bb, bar_dat(bb),0.1, 'DisplayName',env_type{1,bb}, 'LineWidth', 1.0);
            set(b,'FaceColor',col(bb,:))
            hold on
            er = errorbar(0.1 + 0.1*bb ,bar_dat(bb),err(bb),err(bb), 'HandleVisibility','off');    
            er.Color = [0 0 0];  
            er.LineWidth = 1.0;
            er.LineStyle = 'none';  
            hold on
            
            else 
            b = bar(0.15 + 0.1*bb, bar_dat(bb) ,0.1, 'DisplayName',env_type{1,bb}, 'LineWidth', 1.0);
            bb
            set(b,'FaceColor',col(bb,:))
            hold on
            er = errorbar(0.15 + 0.1*bb ,bar_dat(bb) ,err(bb),err(bb), 'HandleVisibility','off');    
            er.Color = [0 0 0];  
            er.LineWidth = 1.0;
            er.LineStyle = 'none';  
            hold on
            end
        end
 set(gca, 'xtick', [0.2; 0.35])
 set(gca, 'xticklabel',{'Flat arena', 'Helical maze'})
xlim([0.0,0.5]);
legend;
ylabel('Aspect ratio');

%% Aspect ratio plot place
place_3d_aspectR = [5.915479627	9.037865039	8.59260074	11.46368305	7.093325464	14.08165105	9.720440142	9.143910521	10.22662194	9.323000962	19.44284581	4.459030428	32.43299344	108.2532259	14.79657666	12.41335478	14.29518995	7.687482319	6.34814228	2.968627544	10.5892718	9.412225351	11.2396932	5.738946788	10.6130073	8.973760724	10.37249712	9.392317085	5.013787917	9.682416731	14.3045145	8.728034447	9.797697149	4.094802876	8.785740392	4.233771952	4.233771952 5.324291976	8.353995549	9.049249636	12.20274122	12.94371039	6.726623302	10.46322803	9.453225441	17.76729113	1.813341844	10.6693525	9.527366407	22.93367581	9.173470324	6.00485192	4.237446142	7.989722022	15.38878219	12.41927471	13.12776996	7.683182436	6.506655007	17.01444186	2.164633354	10.05372712	11.0337279	9.268321618	12.20774655	9.105345202	10.08503703	12.75809629	12.77556902	12.03007519	14.52086939	9.1765345	20.60054715	6.852835361	20.35200834	4.070401667];
place_2d_aspectR = [2.904928466	2.475974833	1.415131231	1.527976687	1.439957401	1.127139174	1.092725463	1.416433403	2.058418221	1.154840966	2	1.923112226	1.421609739	1.283074299	2.809996831	2.426163615	1.441112266	3.933868321	2	1.467598771	1.262814562	4	1.82185316	1.108666796	1.78749679	1.272893473	3.071448571	1.359898364	3.003033072	1.492775262	3.119286799	1.142316185	2.525470603	2.576393719	1.843020881];
place_3d_aspectR_mean = mean(place_3d_aspectR);
place_2d_aspectR_mean = mean(place_2d_aspectR);

place_3d_aspectR_std = std(place_3d_aspectR);
place_2d_aspectR_std = std(place_2d_aspectR);

bar_dat = [place_2d_aspectR_mean; place_3d_aspectR_mean];
err = [place_2d_aspectR_std; place_3d_aspectR_std];
figure;
hold on;
env_type = {'flat arena', 'Helical maze'};
col = [1,1,1; 0.5,0.5,0.5];
        for bb = 1:2
            % bb is bars in bar graph iterator to have different colors
            if bb < 2
            bb
            b = bar(0.1 + 0.1*bb, bar_dat(bb),0.1, 'DisplayName',env_type{1,bb}, 'LineWidth', 1.0);
            set(b,'FaceColor',col(bb,:))
            hold on;
            er = errorbar(0.1 + 0.1*bb ,bar_dat(bb),err(bb),err(bb), 'HandleVisibility','off');    
            er.Color = [0 0 0];  
            er.LineWidth = 1.0;
            er.LineStyle = 'none';  
            %legend(env_type{1, bb})
            %hold on
            
            else 
            b = bar(0.15 + 0.1*bb, bar_dat(bb), 0.1, 'DisplayName', env_type{1, bb}, 'LineWidth', 1.0);
            bb
            set(b,'FaceColor',col(bb,:))
            hold on;
            er = errorbar(0.15 + 0.1*bb ,bar_dat(bb) ,err(bb),err(bb), 'HandleVisibility','off');    
            er.Color = [0 0 0];  
            er.LineWidth = 1.0;
            er.LineStyle = 'none';  
            %legend(env_type{1, bb})
            hold on
            end
        end
 set(gca, 'xtick', [0.2; 0.35])
 set(gca, 'xticklabel',{'Flat arena', 'Helical maze'})
xlim([0.0,0.5]);
legend(env_type, 'Location', 'northwest');
%legend('flat arena','helical maze');
ylabel('Aspect ratio');